package org.msh.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Created by mauri on 29/05/2017.
 */
public class HashUtils {

    public static final String generateHash(String key) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
            md.update(key.getBytes());
            byte[] hashGerado = md.digest();

            StringBuffer ret = new StringBuffer(hashGerado.length);
            for (int i = 0; i < hashGerado.length; i++) {
                String hex = Integer.toHexString(0x0100 + (hashGerado[i] & 0x00FF)).substring(1);
                ret.append((hex.length() < 2 ? "0" : "") + hex);
            }
            return ret.toString();
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error generating hash");
        }
    }

}
